/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.element;

import com.fuzs.puzzleslib_em.PuzzlesLib;
import com.fuzs.puzzleslib_em.config.ConfigManager;
import com.fuzs.puzzleslib_em.element.EventListener;
import com.fuzs.puzzleslib_em.element.IConfigurableElement;
import com.fuzs.puzzleslib_em.element.registry.ElementRegistry;
import com.fuzs.puzzleslib_em.element.side.IClientElement;
import com.fuzs.puzzleslib_em.element.side.ICommonElement;
import com.fuzs.puzzleslib_em.element.side.IServerElement;
import com.fuzs.puzzleslib_em.element.side.ISidedElement;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractElement
extends EventListener
implements IConfigurableElement {
    private final List<EventListener.EventStorage<? extends Event>> eventListeners = Lists.newArrayList();
    private int enabled = this.getDefaultState() ? 1 : 0;

    protected String getRegistryName() {
        return ElementRegistry.getRegistryName(this).func_110623_a();
    }

    @Override
    public final String getDisplayName() {
        return Stream.of(this.getRegistryName().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @Override
    public boolean getDefaultState() {
        return true;
    }

    @Override
    public final void setupGeneralConfig(ForgeConfigSpec.Builder builder) {
        AbstractElement.addToConfig(builder.comment(this.getDescription()).define(this.getDisplayName(), this.getDefaultState()), this::setEnabled);
    }

    public final void setup() {
        this.setupConfig(this.getRegistryName());
        this.setupEvents();
    }

    private void setupConfig(String elementId) {
        Consumer<ICommonElement> commonConfig = element -> ConfigManager.builder().create(elementId, element::setupCommonConfig, ModConfig.Type.COMMON, element.getCommonDescription());
        Consumer<IClientElement> clientConfig = element -> ConfigManager.builder().create(elementId, element::setupClientConfig, ModConfig.Type.CLIENT, element.getClientDescription());
        Consumer<IServerElement> serverConfig = element -> ConfigManager.builder().create(elementId, element::setupServerConfig, ModConfig.Type.SERVER, element.getServerDescription());
        this.setupAllSides(commonConfig, clientConfig, serverConfig);
    }

    private void setupEvents() {
        this.setupAllSides(ICommonElement::setupCommon, IClientElement::setupClient, IServerElement::setupServer);
    }

    private void setupAllSides(Consumer<ICommonElement> commonSetup, Consumer<IClientElement> clientSetup, Consumer<IServerElement> serverSetup) {
        if (this instanceof ICommonElement) {
            commonSetup.accept((ICommonElement)((Object)this));
        }
        if (FMLEnvironment.dist.isClient() && this instanceof IClientElement) {
            clientSetup.accept((IClientElement)((Object)this));
        }
        if (FMLEnvironment.dist.isDedicatedServer() && this instanceof IServerElement) {
            serverSetup.accept((IServerElement)((Object)this));
        }
    }

    public final void load(ParallelDispatchEvent evt) {
        this.initSide(evt);
        if (this instanceof ICommonElement) {
            if (evt instanceof FMLCommonSetupEvent) {
                this.reload(true);
            }
        } else if (evt instanceof FMLClientSetupEvent || evt instanceof FMLDedicatedServerSetupEvent) {
            this.reload(true);
        }
    }

    private void initSide(ParallelDispatchEvent evt) {
        if (evt instanceof FMLCommonSetupEvent && this instanceof ICommonElement) {
            ((ICommonElement)((Object)this)).initCommon();
        } else if (evt instanceof FMLClientSetupEvent && this instanceof IClientElement) {
            ((IClientElement)((Object)this)).initClient();
        } else if (evt instanceof FMLDedicatedServerSetupEvent && this instanceof IServerElement) {
            ((IServerElement)((Object)this)).initServer();
        }
    }

    private void reload(boolean firstLoad) {
        if (this.isEnabled() || this.isAlwaysEnabled()) {
            this.reloadEventListeners(true);
            this.reloadSides(true);
        } else if (!firstLoad) {
            this.reloadEventListeners(false);
            this.reloadSides(false);
        }
    }

    private void reloadEventListeners(boolean enable) {
        if (enable) {
            this.getEventListeners().forEach(EventListener.EventStorage::register);
        } else {
            this.getEventListeners().forEach(EventListener.EventStorage::unregister);
        }
    }

    private void reloadSides(boolean enable) {
        Consumer<ICommonElement> reloadCommon = element -> this.reloadSpecificSide((ISidedElement)element, enable, ICommonElement::loadCommon, ICommonElement::unloadCommon);
        Consumer<IClientElement> reloadClient = element -> this.reloadSpecificSide((ISidedElement)element, enable, IClientElement::loadClient, IClientElement::unloadClient);
        Consumer<IServerElement> reloadServer = element -> this.reloadSpecificSide((ISidedElement)element, enable, IServerElement::loadServer, IServerElement::unloadServer);
        this.setupAllSides(reloadCommon, reloadClient, reloadServer);
    }

    private <T extends ISidedElement> void reloadSpecificSide(T element, boolean enable, Consumer<T> load, Consumer<T> unload) {
        if (enable) {
            load.accept(element);
        } else {
            unload.accept(element);
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled == 1;
    }

    public boolean isAlwaysEnabled() {
        return false;
    }

    private void setEnabled(boolean enabled) {
        this.setEnabled(enabled ? 1 : 0);
    }

    private void setEnabled(int enabled) {
        if (this.enabled != -1 && this.enabled != enabled) {
            this.enabled = enabled;
            this.reload(false);
        }
    }

    protected void forceDisable() {
        this.setEnabled(-1);
        PuzzlesLib.LOGGER.warn("Detected issue in {} element: {}", (Object)this.getDisplayName(), (Object)"Disabling until game restart");
    }

    @Override
    public final List<EventListener.EventStorage<? extends Event>> getEventListeners() {
        return this.eventListeners;
    }
}

